#include <stdio.h>
#include <stdlib.h>
#include "reader.h"

int CountSubfiles(FILE *file)
{
	int Size;

	if (file==NULL)
		return 0;

	fseek(file, 0, SEEK_SET);
	if (fread(&Size, 4, 1, file)==0)
		return 0;

	return Size;
}

int ReadSubfileInfos(FILE *file, DWORD Index, DWORD *pLen, DWORD *ptype,
					  char FName[])
{
	if ((file==NULL)||(pLen==NULL)||(ptype==NULL)||(FName==NULL))
		return 0;

	// 4 : Number of subfiles in package
	// Index * 4 : Number of subfiles info to skip
	// 32 : Subfile name
	fseek(file, 4 + Index * (4+4+32), SEEK_SET);
	fread(pLen, 4, 1, file);
	fread(ptype, 4, 1, file);
	fread(&FName[0], 32, 1, file);

	return 1;
}

int ReadSubfile(FILE *file, DWORD Index, char *Buff)
{
	DWORD Len;

	if ((file==NULL)||(Buff==NULL))
		return 0;

	SeekToSubfile(file, Index, &Len);
	fread(Buff, Len, 1, file);

	return 1;
}

int SeekToSubfile(FILE *file, DWORD Index, DWORD *pSize)
{
	int NbSubfiles;
	DWORD Offset = 0;
	DWORD LenTmp, TypeTmp;
	char szNameTmp[32];
	DWORD Cpt1;

	if ((file==NULL)||(pSize==NULL))
		return 0;

	for(Cpt1=0;Cpt1<Index;Cpt1++)
	{
		ReadSubfileInfos(file, Cpt1, &LenTmp, &TypeTmp, szNameTmp);
		Offset += LenTmp;
	}

	ReadSubfileInfos(file, Index, pSize, &TypeTmp, szNameTmp);

	NbSubfiles = CountSubfiles(file);
	fseek(file, 4 + NbSubfiles * (4+4+32) + Offset, SEEK_SET);

	return 1;
}